/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.springframework.util.ObjectUtils;

public class EsNewsInfoProcessor
implements EsResultProcessor<EsPagedResult<EsSearchResult>> {
    private static Logger logger = LogManager.getLogger(EsNewsInfoProcessor.class);
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public EsPagedResult<EsSearchResult> processResult(EsFeedbackQuery query, SearchResponse response) {
        SearchHit[] searchHits;
        EsSearchResult searchResult = new EsSearchResult();
        ArrayList<NewsInfo> records = new ArrayList<NewsInfo>();
        EsPagedResult<EsSearchResult> pageResult = new EsPagedResult<EsSearchResult>();
        pageResult.setTotalCount((int)response.getHits().getTotalHits());
        pageResult.setToPage(query.getPageIndex());
        pageResult.setPageSize(query.getPageSize());
        pageResult.setTotalPages(pageResult.getTotalPages());
        pageResult.setResult(searchResult);
        for (SearchHit searchHit : searchHits = response.getHits().getHits()) {
            Map source = searchHit.getSource();
            NewsInfo record = null;
            if (!source.isEmpty()) {
                Object o = source.get("keywords");
                String keywords = null;
                if (o != null) {
                    keywords = o.toString();
                }
                if ("[]".equals(keywords)) {
                    source.put("keywords", "");
                }
                try {
                    record = (NewsInfo)JSON.parseObject((String)JSON.toJSONString((Object)source), NewsInfo.class);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    continue;
                }
            }
            records.add(record);
        }
        searchResult.setRecords(records);
        return pageResult;
    }

    @Override
    public EsPagedResult<EsSearchResult> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        Integer pageIndex = query.getPageIndex();
        Integer pageSize = query.getPageSize();
        Terms agg = (Terms)response.getAggregations().get("agg");
        Integer totalCount = agg.getBuckets().size();
        EsSearchResult searchResult = new EsSearchResult();
        ArrayList<NewsInfo> records = new ArrayList<NewsInfo>();
        EsPagedResult<EsSearchResult> pageResult = new EsPagedResult<EsSearchResult>();
        pageResult.setTotalCount(totalCount);
        pageResult.setToPage(pageIndex);
        pageResult.setPageSize(pageSize);
        pageResult.setTotalPages(pageResult.getTotalPages());
        for (Terms.Bucket entry : agg.getBuckets()) {
            Object key = entry.getKey();
            long docCount = entry.getDocCount();
            if (ObjectUtils.isEmpty((Object)key) || docCount == 0L) continue;
            TopHits topHits = (TopHits)entry.getAggregations().get("top");
            SearchHit[] searchHits = topHits.getHits().getHits();
            Avg avg = (Avg)entry.getAggregations().get("avg_emotionScore");
            double value = avg.getValue();
            Integer emotionScore = Integer.parseInt(new DecimalFormat("0").format(value));
            Long pointsCount = docCount;
            for (SearchHit searchHit : searchHits) {
                Map source = searchHit.getSource();
                NewsInfo record = null;
                if (!source.isEmpty()) {
                    Object o = source.get("keywords");
                    String keywords = null;
                    if (o != null) {
                        keywords = o.toString();
                    }
                    if ("[]".equals(keywords)) {
                        source.put("keywords", "");
                    }
                    try {
                        record = (NewsInfo)JSON.parseObject((String)JSON.toJSONString((Object)source), NewsInfo.class);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        continue;
                    }
                }
                if (emotionScore != null) {
                    record.setEmotionScore(emotionScore);
                }
                if (pointsCount != null) {
                    record.setPointsCount(pointsCount);
                }
                records.add(record);
            }
        }
        searchResult.setRecords(records);
        pageResult.setResult(searchResult);
        return pageResult;
    }

    public static void main(String[] args) {
        List list = (List)JSON.parseObject((String)" [\"\u8131\u6b27\u534f\u8bae\",\"\u5ef6\u671f\u8131\u6b27\",\"\u81f4\u4fe1\u6b27\u76df\",\"\u8bae\u4f1a\u9662\",\"\u4ea4\u7531\u8bae\u4f1a\",\"\u4fe1\u4e2d\",\"\u82f1\u56fd\u5ef6\u671f\",\"\u82f1\u56fd\u8bae\u4f1a\",\"\u7533\u8bf7\u5ef6\u671f\",\"\u65f6\u653f\u8981\u95fb\"]", List.class);
        System.out.println(list);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

