/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.utils.ProcessorUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public class EsTotalScaleByTimeProcessor
implements EsResultProcessor<EsFacetResult<HotEventStatistic>> {
    private static Logger logger = LogManager.getLogger(EsTotalScaleByTimeProcessor.class);
    private static List<String> aggNames = new ArrayList<String>();
    private String timeFormat;
    private Map<String, String> map;

    public EsTotalScaleByTimeProcessor(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public EsTotalScaleByTimeProcessor(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResult(EsFeedbackQuery query, SearchResponse response) {
        if (StringUtils.isBlank((CharSequence)this.timeFormat)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.timeFormat);
        EsFacetResult<HotEventStatistic> facetResult = null;
        try {
            ArrayList list = new ArrayList();
            HotEventStatistic statistic = new HotEventStatistic();
            ArrayList<Trend<Long>> doc_count = new ArrayList<Trend<Long>>();
            ArrayList<Trend<Double>> emotion_value = new ArrayList<Trend<Double>>();
            ArrayList<Trend<Long>> media_cover = new ArrayList<Trend<Long>>();
            ArrayList<Trend<Map<String, Long>>> source_value = new ArrayList<Trend<Map<String, Long>>>();
            ArrayList<Trend<Long>> topic_count = new ArrayList<Trend<Long>>();
            MultiBucketsAggregation agg = (MultiBucketsAggregation)response.getAggregations().get("agg");
            for (MultiBucketsAggregation.Bucket entry : agg.getBuckets()) {
                String keyAsString = entry.getKeyAsString();
                long time = dateFormat.parse(keyAsString).getTime();
                for (String aggName : aggNames) {
                    Aggregation aggregation = entry.getAggregations().get(aggName);
                    if (aggregation == null) continue;
                    switch (aggName) {
                        case "emotion_score": {
                            Double avg = ProcessorUtils.getAvg(aggregation);
                            emotion_value.add(new Trend<Double>(time, avg));
                            break;
                        }
                        case "cluster_id": {
                            Long clusterId = ProcessorUtils.InternalCardinality(aggregation);
                            topic_count.add(new Trend<Long>(time, clusterId));
                            break;
                        }
                        case "tb_nickname": {
                            Long tbNickname = ProcessorUtils.InternalCardinality(aggregation);
                            media_cover.add(new Trend<Long>(time, tbNickname));
                            break;
                        }
                        case "url_MD5": {
                            Long urlMD5 = ProcessorUtils.InternalCardinality(aggregation);
                            doc_count.add(new Trend<Long>(time, urlMD5));
                            break;
                        }
                        case "source": {
                            Map<String, Long> stringLongMap = ProcessorUtils.StringTerms(aggregation);
                            source_value.add(new Trend<Map<String, Long>>(time, stringLongMap));
                            break;
                        }
                    }
                }
            }
            if (!doc_count.isEmpty()) {
                statistic.setDoc_count(doc_count);
            }
            if (!emotion_value.isEmpty()) {
                statistic.setEmotion_value(emotion_value);
            }
            if (!topic_count.isEmpty()) {
                statistic.setTopic_count(topic_count);
            }
            if (!media_cover.isEmpty()) {
                statistic.setMedia_cover(media_cover);
            }
            if (!source_value.isEmpty()) {
                statistic.setSource_value(source_value);
            }
            facetResult = new EsFacetResult<HotEventStatistic>(statistic, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<HotEventStatistic>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }

    static {
        aggNames.add("url_MD5");
        aggNames.add("source");
        aggNames.add("tb_nickname");
    }
}

