/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.utils.ProcessorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;

public class EsTotalScaleProcessor
implements EsResultProcessor<EsFacetResult<HotEventStatistic>> {
    private static Logger logger = LogManager.getLogger(EsTotalScaleProcessor.class);
    private static List<String> aggNames = new ArrayList<String>();
    private Map<String, String> map;

    public EsTotalScaleProcessor() {
    }

    public EsTotalScaleProcessor(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResult(EsFeedbackQuery query, SearchResponse response) {
        EsFacetResult<HotEventStatistic> facetResult = null;
        try {
            ArrayList list = new ArrayList();
            HotEventStatistic statistic = new HotEventStatistic();
            ArrayList<Trend<Long>> doc_count = new ArrayList<Trend<Long>>();
            ArrayList<Trend<Double>> emotion_value = new ArrayList<Trend<Double>>();
            ArrayList<Trend<Long>> media_cover = new ArrayList<Trend<Long>>();
            ArrayList<Trend<Double>> heat_value = new ArrayList<Trend<Double>>();
            ArrayList<Trend<Long>> topic_count = new ArrayList<Trend<Long>>();
            ArrayList<Trend<Map<String, Long>>> source_value = new ArrayList<Trend<Map<String, Long>>>();
            ArrayList<Trend<Map<String, Long>>> emotion_tendency = new ArrayList<Trend<Map<String, Long>>>();
            for (String key : aggNames) {
                Aggregation aggregation = response.getAggregations().get(key);
                if (aggregation == null) continue;
                long nowTime = System.currentTimeMillis();
                switch (key) {
                    case "emotion_score": {
                        Double avg = ProcessorUtils.getAvg(aggregation);
                        emotion_value.add(new Trend<Double>(nowTime, avg));
                        break;
                    }
                    case "emotion_tendency": {
                        Map<String, Long> emotionLongMap = ProcessorUtils.LongTerms(aggregation);
                        emotion_tendency.add(new Trend<Map<String, Long>>(nowTime, emotionLongMap));
                        break;
                    }
                    case "cluster_id": {
                        Long clusterId = ProcessorUtils.InternalCardinality(aggregation);
                        topic_count.add(new Trend<Long>(nowTime, clusterId));
                        break;
                    }
                    case "tb_nickname": {
                        Long tbNickname = ProcessorUtils.InternalCardinality(aggregation);
                        media_cover.add(new Trend<Long>(nowTime, tbNickname));
                        break;
                    }
                    case "url_MD5": {
                        Long urlMD5 = ProcessorUtils.InternalCardinality(aggregation);
                        doc_count.add(new Trend<Long>(nowTime, urlMD5));
                        break;
                    }
                    case "source": {
                        Map<String, Long> stringLongMap = ProcessorUtils.StringTerms(aggregation);
                        source_value.add(new Trend<Map<String, Long>>(nowTime, stringLongMap));
                        break;
                    }
                }
            }
            statistic.setDoc_count(doc_count);
            statistic.setEmotion_value(emotion_value);
            statistic.setTopic_count(topic_count);
            statistic.setMedia_cover(media_cover);
            statistic.setHeat_value(heat_value);
            statistic.setSource_value(source_value);
            statistic.setEmotion_tendency_value(emotion_tendency);
            facetResult = new EsFacetResult<HotEventStatistic>(statistic, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<HotEventStatistic>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }

    static {
        aggNames.add("emotion_score");
        aggNames.add("emotion_tendency");
        aggNames.add("cluster_id");
        aggNames.add("tb_nickname");
        aggNames.add("url_MD5");
        aggNames.add("source");
    }
}

