/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.utils;

import org.apache.commons.lang3.StringUtils;

public enum TimeEnum {
    HOUR("hour", "yyyy-MM-dd HH"),
    MINUTE("minute", "yyyy-MM-dd HH:mm"),
    SECONDS("seconds", "yyyy-MM-dd HH:mm:ss"),
    DAY("day", "yyyy-MM-dd"),
    WEEK("week", "yyyy-MM-dd"),
    MONTH("month", "yyyy-MM"),
    QUARTER("quarter", "yyyy-MM"),
    YEAR("year", "yyyy");

    private String timeType;
    private String timeFormat;

    private TimeEnum(String timeType, String timeFormat) {
        this.timeType = timeType;
        this.timeFormat = timeFormat;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public static TimeEnum getTimeEnum(String timeType) {
        if (StringUtils.isBlank((CharSequence)timeType)) {
            return HOUR;
        }
        switch (timeType) {
            case "hour": {
                return HOUR;
            }
            case "minute": {
                return MINUTE;
            }
            case "second": {
                return SECONDS;
            }
            case "day": {
                return DAY;
            }
            case "week": {
                return WEEK;
            }
            case "month": {
                return MONTH;
            }
            case "quarter": {
                return QUARTER;
            }
            case "year": {
                return YEAR;
            }
        }
        return HOUR;
    }
}

