/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.utils;

import com.chinamcloud.haihe.common.bean.Trend;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToolUtils {
    private static Logger logger = LogManager.getLogger(ToolUtils.class);

    public static Double HeatCalculation(List<Trend<Map<String, Long>>> mapList, Integer cardinal) {
        Long news = 0L;
        Long epaper = 0L;
        Long weiXin = 0L;
        Long weibo = 0L;
        Long app = 0L;
        if (mapList != null && !mapList.isEmpty()) {
            for (Trend<Map<String, Long>> mapTrend : mapList) {
                Map<String, Long> map = mapTrend.getValue();
                Long news_num = map.get("News");
                Long epaper_num = map.get("EPAPER");
                Long weiXin_num = map.get("WeiXin");
                Long weibo_num = map.get("Weibo");
                Long app_num = map.get("App");
                news = news + (news_num == null ? 0L : news_num);
                epaper = epaper + (epaper_num == null ? 0L : epaper_num);
                weiXin = weiXin + (weiXin_num == null ? 0L : weiXin_num);
                weibo = weibo + (weibo_num == null ? 0L : weibo_num);
                app = app + (app_num == null ? 0L : app_num);
            }
        }
        return ToolUtils.HeatCalculation(news, epaper, weiXin, weibo, app, cardinal);
    }

    public static Double HeatCalculation(Map<String, Long> map, Integer cardinal) {
        Long news = 0L;
        Long epaper = 0L;
        Long weiXin = 0L;
        Long weibo = 0L;
        Long app = 0L;
        Long news_num = map.get("News");
        Long epaper_num = map.get("EPAPER");
        Long weiXin_num = map.get("WeiXin");
        Long weibo_num = map.get("Weibo");
        Long app_num = map.get("App");
        news = news + (news_num == null ? 0L : news_num);
        epaper = epaper + (epaper_num == null ? 0L : epaper_num);
        weiXin = weiXin + (weiXin_num == null ? 0L : weiXin_num);
        weibo = weibo + (weibo_num == null ? 0L : weibo_num);
        app = app + (app_num == null ? 0L : app_num);
        return ToolUtils.HeatCalculation(news, epaper, weiXin, weibo, app, cardinal);
    }

    public static Double HeatCalculation(Long news, Long epaper, Long weiXin, Long weibo, Long app, Integer cardinal) {
        double x1 = (double)news.longValue() * 0.6 + (double)epaper.longValue() * 0.4;
        double x2 = (double)weiXin.longValue() * 0.4 + (double)weibo.longValue() * 0.4 + (double)app.longValue() * 0.2;
        double a1 = 1.005;
        double a2 = 1.01;
        Double b1 = 0.4;
        Double b2 = 0.6;
        long x = System.currentTimeMillis();
        double pow2 = Math.pow(a2, x2);
        double pow1 = Math.pow(a1, x1);
        Double y1 = (pow1 - 1.0) / (pow1 + 1.0);
        Double y2 = (pow2 - 1.0) / (pow2 + 1.0);
        Double R = (y1 * b1 + y2 * b2) * (double)(100 - cardinal) + (double)cardinal.intValue();
        return R;
    }
}

