/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.backStageManagement.service.RegionService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.afterprocessor.ArealDistributionProcessor;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.TrendProcessor;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.agg.EsTermBucketAgg;
import com.chinamcloud.haihe.es.controller.EsExclusiveController;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleProcessor;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmParam;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.mapper.AlarmInfoMapper;
import com.chinamcloud.haihe.newservice.analysis.mapper.EventInfoMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm-service"})
public class AlarmController {
    private final Logger logger = LoggerFactory.getLogger(AlarmController.class);
    @Autowired
    private AlarmInfoMapper alarmInfoMapper;
    @Autowired
    private EventInfoMapper eventInfoMapper;
    @Autowired
    private RegionService regionService;
    @Autowired
    private EsExclusiveController esExclusiveController;
    @Autowired
    private EsNewsDataController esNewsDataController;

    @UserLoginToken
    @RequestMapping(value={"/profile"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmProfile(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        return this.esExclusiveController.profile(hotParams, (List<String>)new ArrayList<String>(){
            {
                this.add("total");
                this.add("negative");
                this.add("extreme");
                this.add("today");
            }
        });
    }

    @UserLoginToken
    @RequestMapping(value={"/funnelPlot"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmFunnelPlot(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        return this.esExclusiveController.profile(hotParams, (List<String>)new ArrayList<String>(){
            {
                this.add("allTotal");
                this.add("total");
                this.add("negative");
                this.add("extreme");
            }
        });
    }

    @UserLoginToken
    @PostMapping(value={"/getPublishingTrend"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmPublishingTrend(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String timeType = alarmParam.getTimeType();
        TimeEnum timeEnum = TimeEnum.getTimeEnum(timeType);
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        if (StringUtils.isBlank((CharSequence)hotParams.getDay())) {
            List<Date> dateList = DateUtils.GetTime(-2, true, "week");
            hotParams.setFromDt(dateList.get(0));
            hotParams.setToDt(dateList.get(1));
        }
        hotParams.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeEnum.getTimeFormat()));
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url_MD5", "cardinality");
            }
        }, timeEnum));
        hotParams.setAfterProcessor(new TrendProcessor((List<String>)new ArrayList<String>(){
            {
                this.add("doc_num");
            }
        }));
        return this.esNewsDataController.trend(hotParams);
    }

    @UserLoginToken
    @RequestMapping(value={"/getRepeatedNum"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmRepeatedNum(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        String facetField = hotParams.getFacetField();
        Integer size = alarmParam.getSize();
        hotParams.setFacetLimit(size == null ? 100 : size);
        if ("tb_nickname".equals(facetField)) {
            hotParams.setAgainFacetField("logoUrl");
        }
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        hotParams.setAfterProcessor(new RepetitionAfterProcessor(alarmParam.getFacetField()));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @RequestMapping(value={"/ArealDistribution"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmArealDistribution(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        List<String> regionNames = alarmParam.getRegionNames();
        if (regionNames == null || regionNames.isEmpty()) {
            Integer regionCode = alarmParam.getRegionCode();
            CodeResult<List<Map<String, Object>>> addrTree = null;
            addrTree = regionCode == null ? this.regionService.getProvinces() : this.regionService.getAddrTree(regionCode.toString());
            if (regionNames == null) {
                regionNames = new ArrayList<String>();
            }
            List<Map<String, Object>> result = addrTree.getResult();
            for (Map<String, Object> map : result) {
                Object name = map.get("name");
                if (name == null) continue;
                regionNames.add(name.toString());
            }
        }
        if (regionNames.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ArrayList<TermAggBucket> termAggBuckets = new ArrayList();
        termAggBuckets = regionNames.stream().map(x -> {
            if (x.endsWith("\u7701")) {
                return x.substring(0, x.lastIndexOf("\u7701"));
            }
            if (x.endsWith("\u5e02")) {
                return x.substring(0, x.lastIndexOf("\u5e02"));
            }
            if (x.endsWith("\u81ea\u6cbb\u533a")) {
                return x.substring(0, x.lastIndexOf("\u81ea\u6cbb\u533a"));
            }
            if (x.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                return x.substring(0, x.lastIndexOf("\u7279\u522b\u884c\u653f\u533a"));
            }
            if (x.endsWith("\u533a")) {
                return x.substring(0, x.lastIndexOf("\u533a"));
            }
            return x;
        }).collect(Collectors.toList()).stream().map(x -> new TermAggBucket(Arrays.asList(x), alarmParam.getRegionType(), (String)x)).collect(Collectors.toList());
        hotParams.setFacetField(alarmParam.getRegionType());
        hotParams.setNonEmptyField(alarmParam.getRegionType());
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsTermBucketAgg(termAggBuckets));
        hotParams.setAfterProcessor(new ArealDistributionProcessor(regionNames));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @RequestMapping(value={"/LatestNews"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object alarmLatestNews(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setSortFields((List<String>)new ArrayList<String>(){
            {
                this.add("pubTime desc");
            }
        });
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor("list"));
        return this.esNewsDataController.getNewsList(hotParams);
    }

    @UserLoginToken
    @RequestMapping(value={"/getGrade"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getGrade(@RequestBody AlarmParam alarmParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        alarmParam.setUserToken(user_token);
        HotParams hotParams = this.getHotParamsByAlarmInfo(alarmParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        hotParams.setEsResultProcessor(new EsTotalScaleProcessor());
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tb_nickname", "cardinality");
                this.put("url_MD5", "cardinality");
            }
        }));
        return this.esExclusiveController.getGrade(hotParams, alarmParam.getEmotionUpper(), alarmParam.getEmotionLower() == null ? -99 : alarmParam.getEmotionLower());
    }

    private HotParams getHotParamsByAlarmInfo(AlarmParam alarmInfoBean) {
        if (alarmInfoBean == null || StringUtils.isBlank((CharSequence)alarmInfoBean.getUserToken()) || alarmInfoBean.getPlanId() == null || alarmInfoBean.getPlanId() == null && alarmInfoBean.getAlarmId() == null) {
            throw new CustomException("params_error");
        }
        List<AlarmInfoBean> alarmInfoList = this.alarmInfoMapper.getAlarmInfoList(alarmInfoBean.getUserToken(), alarmInfoBean.getPlanId(), alarmInfoBean.getAlarmId());
        if (alarmInfoList == null || alarmInfoList.isEmpty()) {
            PlanInfoBean planInfoBean = new PlanInfoBean(alarmInfoBean.getUserToken(), alarmInfoBean.getPlanId().intValue(), null, null, null, null);
            List<PlanInfoBean> planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfoBean);
            if (planInfoBeanList == null || planInfoBeanList.isEmpty()) {
                throw new CustomException("the_plan_found_empty");
            }
            alarmInfoBean.setKeywords(planInfoBeanList.get(0).getKeyWords());
            alarmInfoBean.setLocation(planInfoBeanList.get(0).getLocation());
        } else {
            alarmInfoBean.editAlarmParam(alarmInfoList.get(0));
        }
        final String keywords = alarmInfoBean.getKeywords();
        final String noKeywords = alarmInfoBean.getNoKeywords();
        String location = alarmInfoBean.getLocation();
        Integer size = alarmInfoBean.getSize();
        Integer page = alarmInfoBean.getPage();
        String facetField = alarmInfoBean.getFacetField();
        String emotionTendency = alarmInfoBean.getEmotionTendency();
        Date fromDt = alarmInfoBean.getFromDt();
        Date toDt = alarmInfoBean.getToDt();
        String day = alarmInfoBean.getDay();
        HotParams hotParams = new HotParams();
        if (StringUtils.isNotBlank((CharSequence)keywords)) {
            hotParams.setKeyWords((List<String>)new ArrayList<String>(){
                {
                    this.add(keywords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)noKeywords)) {
            hotParams.setNoKeywords((List<String>)new ArrayList<String>(){
                {
                    this.add(noKeywords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)location)) {
            if ("title".equals(location)) {
                hotParams.setUseKeyWord("subject");
            }
            if ("content".equals(location)) {
                hotParams.setUseKeyWord("description");
            }
            if ("all".equals(location)) {
                hotParams.setUseKeyWord("all");
            }
        }
        if (size != null) {
            hotParams.setSize(size);
        }
        if (page != null) {
            hotParams.setPage(page);
        }
        if (StringUtils.isNotBlank((CharSequence)facetField)) {
            hotParams.setFacetField(facetField);
        }
        if (StringUtils.isNotBlank((CharSequence)emotionTendency)) {
            hotParams.setEmotionTendency(emotionTendency);
        }
        if (StringUtils.isNotBlank((CharSequence)day)) {
            hotParams.setDay(day);
        } else {
            if (fromDt != null) {
                hotParams.setFromDt(fromDt);
            }
            if (toDt != null) {
                hotParams.setToDt(toDt);
            }
        }
        return hotParams;
    }
}

