/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.service.AlarmInfoService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm-info"})
public class AlarmInfoController {
    private final Logger logger = LoggerFactory.getLogger(AlarmInfoService.class);
    @Autowired
    private AlarmInfoService alarmInfoService;

    @UserLoginToken
    @PostMapping(value={"/alarmInfoList"})
    public Object getAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        return this.alarmInfoService.getAlarmInfoBeanList(user_token, alarmInfoBean.getPlanId(), alarmInfoBean.getAlarmId());
    }

    @UserLoginToken
    @PostMapping(value={"/add"})
    public Object addAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        alarmInfoBean.setUserToken(user_token);
        return this.alarmInfoService.add(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/update"})
    public Object updateAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        if (alarmInfoBean == null) {
            this.logger.error("\u4f20\u5165alarmInfoBean\u4e3a\u7a7a");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        alarmInfoBean.setUserToken(user_token);
        return this.alarmInfoService.update(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/delete"})
    public Object deleteAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        return this.alarmInfoService.delete(user_token, alarmInfoBean.getAlarmId());
    }
}

