/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmReceiveBean;
import com.chinamcloud.haihe.newservice.analysis.service.AlarmReceiveService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm-receive"})
public class AlarmReceiveController {
    private final Logger logger = LoggerFactory.getLogger(AlarmReceiveController.class);
    @Autowired
    private AlarmReceiveService alarmReceiveService;

    @UserLoginToken
    @PostMapping(value={"/alarmReceiveList"})
    public Object getAlarmReceive(@RequestBody AlarmInfoBean alarmInfoBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        return this.alarmReceiveService.getAlarmReceiveBeanList(user_token, alarmInfoBean.getAlarmId());
    }

    @UserLoginToken
    @PostMapping(value={"/add"})
    public Object addAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        alarmReceiveBean.setUserToken(user_token);
        return this.alarmReceiveService.add(alarmReceiveBean);
    }

    @UserLoginToken
    @PostMapping(value={"/update"})
    public Object updateAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        alarmReceiveBean.setUserToken(user_token);
        return this.alarmReceiveService.update(alarmReceiveBean);
    }

    @UserLoginToken
    @PostMapping(value={"/delete"})
    public Object deleteAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        return this.alarmReceiveService.delete(user_token, alarmReceiveBean.getId());
    }
}

