/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.service.EventInfoService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/event-info"})
public class EventInfoController {
    @Autowired
    private EventInfoService eventInfoService;

    @UserLoginToken
    @PostMapping(value={"/planList"})
    public Object planList(HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        this.eventInfoService.addDefaultData();
        return this.eventInfoService.planList(user_token);
    }

    @PostMapping(value={"/addPlan"})
    @UserLoginToken
    public Object addPlan(@RequestBody PlanInfoBean planInfo, HttpServletRequest request) {
        if (planInfo == null || StringUtils.isBlank((CharSequence)planInfo.getKeyWords()) || StringUtils.isBlank((CharSequence)planInfo.getName())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (StringUtils.isBlank((CharSequence)planInfo.getLocation())) {
            planInfo.setLocation("all");
        }
        String user_token = request.getAttribute("user_token").toString();
        planInfo.setUser_token(user_token);
        Integer planId = Math.abs(StringUtils.join((Object[])new String[]{user_token, planInfo.getName()}).hashCode());
        planInfo.setPlanId(planId);
        return this.eventInfoService.addPlan(planInfo);
    }

    @PostMapping(value={"/switchPlan"})
    @UserLoginToken
    public Object switchPlan(@RequestBody PlanInfoBean planInfo, HttpServletRequest request) {
        if (planInfo == null || StringUtils.isBlank((CharSequence)planInfo.getName())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String user_token = request.getAttribute("user_token").toString();
        planInfo.setUser_token(user_token);
        return this.eventInfoService.switchPlan(planInfo);
    }

    @PostMapping(value={"/deletePlan"})
    @UserLoginToken
    public Object deletePlan(@RequestBody PlanInfoBean planInfo, HttpServletRequest request) {
        if (planInfo == null || StringUtils.isBlank((CharSequence)planInfo.getName())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String user_token = request.getAttribute("user_token").toString();
        planInfo.setUser_token(user_token);
        return this.eventInfoService.deletePlan(planInfo);
    }

    @PostMapping(value={"/refreshPlan"})
    @UserLoginToken
    public Object refreshPlan(@RequestBody PlanInfoBean planInfo, HttpServletRequest request) {
        if (planInfo == null || StringUtils.isBlank((CharSequence)planInfo.getName())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String user_token = request.getAttribute("user_token").toString();
        planInfo.setUser_token(user_token);
        return this.eventInfoService.refreshPlan(planInfo);
    }
}

