/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.backStageManagement.service.RegionService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.afterprocessor.ArealDistributionProcessor;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.TrendProcessor;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.common.utils.TopicKeywordUtils;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.agg.EsHotTopicAgg;
import com.chinamcloud.haihe.es.agg.EsTermBucketAgg;
import com.chinamcloud.haihe.es.controller.EsExclusiveController;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.es.result.EsHotTopicResultProcessor;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleProcessor;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.bean.SearchSpreadNewsParam;
import com.chinamcloud.haihe.newservice.analysis.bean.SpreadParam;
import com.chinamcloud.haihe.newservice.analysis.mapper.EventInfoMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spread-service"})
public class SpreadController {
    private final Logger logger = LoggerFactory.getLogger(SpreadController.class);
    @Autowired
    private EventInfoMapper eventInfoMapper;
    @Autowired
    private RegionService regionService;
    @Autowired
    private EsNewsDataController esNewsDataController;
    @Autowired
    private EsExclusiveController esExclusiveController;

    @UserLoginToken
    @PostMapping(value={"/getLatestNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getLatestNews(@RequestBody SpreadParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setSortFields((List<String>)new ArrayList<String>(){
            {
                this.add("pubTime desc");
            }
        });
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor("list"));
        return this.esNewsDataController.getNewsList(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getRepeatedNum"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getRepeatedNum(@RequestBody SpreadParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        String facetField = hotParams.getFacetField();
        Integer size = spreadParam.getSize();
        hotParams.setFacetLimit(size == null ? 100 : size);
        if ("tb_nickname".equals(facetField)) {
            hotParams.setAgainFacetField("logoUrl");
        }
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        hotParams.setAfterProcessor(new RepetitionAfterProcessor(spreadParam.getFacetField()));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getArealDistribution"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1 || #result == null")
    public Object getArealDistribution(@RequestBody SpreadParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        List<String> regionNames = spreadParam.getRegionNames();
        if (regionNames == null || regionNames.isEmpty()) {
            Integer regionCode = spreadParam.getRegionCode();
            CodeResult<List<Map<String, Object>>> addrTree = null;
            addrTree = regionCode == null ? this.regionService.getProvinces() : this.regionService.getAddrTree(regionCode.toString());
            if (regionNames == null) {
                regionNames = new ArrayList<String>();
            }
            List<Map<String, Object>> result = addrTree.getResult();
            for (Map<String, Object> map : result) {
                Object name = map.get("name");
                if (name == null) continue;
                regionNames.add(name.toString());
            }
        }
        if (regionNames.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ArrayList<TermAggBucket> termAggBuckets = new ArrayList();
        termAggBuckets = regionNames.stream().map(x -> {
            if (x.endsWith("\u7701")) {
                return x.substring(0, x.lastIndexOf("\u7701"));
            }
            if (x.endsWith("\u5e02")) {
                return x.substring(0, x.lastIndexOf("\u5e02"));
            }
            if (x.endsWith("\u81ea\u6cbb\u533a")) {
                return x.substring(0, x.lastIndexOf("\u81ea\u6cbb\u533a"));
            }
            if (x.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                return x.substring(0, x.lastIndexOf("\u7279\u522b\u884c\u653f\u533a"));
            }
            if (x.endsWith("\u533a")) {
                return x.substring(0, x.lastIndexOf("\u533a"));
            }
            return x;
        }).collect(Collectors.toList()).stream().map(x -> new TermAggBucket(Arrays.asList(x), spreadParam.getRegionType(), (String)x)).collect(Collectors.toList());
        hotParams.setFacetField(spreadParam.getRegionType());
        hotParams.setNonEmptyField(spreadParam.getRegionType());
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsTermBucketAgg(termAggBuckets));
        hotParams.setAfterProcessor(new ArealDistributionProcessor(regionNames));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getTotalScale"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getTotalScale(@RequestBody SpreadParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        hotParams.setEsResultProcessor(new EsTotalScaleProcessor());
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("emotion_score", "avg");
                this.put("cluster_id", "cardinality");
                this.put("tb_nickname", "cardinality");
                this.put("url_MD5", "cardinality");
            }
        }));
        return this.esExclusiveController.totalScale(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getPublishingTrend"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getPublishingTrend(@RequestBody SpreadParam spreadParam, HttpServletRequest request) {
        TimeEnum timeEnum = TimeEnum.getTimeEnum(spreadParam.getTimeType());
        String timeType = "yyyy-MM-dd";
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        List<Date> dateList = DateUtils.GetTime(-2, true, "week");
        hotParams.setFromDt(dateList.get(0));
        hotParams.setToDt(dateList.get(1));
        hotParams.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeType));
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("source", "terms");
            }
        }, timeEnum));
        hotParams.setAfterProcessor(new TrendProcessor((List<String>)new ArrayList<String>(){
            {
                this.add("source");
            }
        }));
        return this.esNewsDataController.trend(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getHotTopic"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getHotTopic(@RequestBody SearchSpreadNewsParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        if (spreadParam.getDay() == null && (spreadParam.getFromDt() == null || spreadParam.getToDt() == null)) {
            spreadParam.setDay("30");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        Integer size = spreadParam.getSize();
        hotParams.setFacetLimit(size == null ? 10 : size);
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsHotTopicResultProcessor(hotParams.getPage(), hotParams.getSize()));
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.TOPIC));
        hotParams.setIEsBuildAgg(new EsHotTopicAgg((List<String>)new ArrayList<String>(){
            {
                this.add("hot");
            }
        }));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor("list", hotParams.getPage(), hotParams.getSize()));
        return this.esNewsDataController.hotTopic(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/searchNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object searchNews(@RequestBody SearchSpreadNewsParam spreadParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            this.logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        spreadParam.setUser_token(user_token);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam);
        HotParamsUtils.setKeyWord(hotParams);
        Integer size = spreadParam.getSize();
        if (hotParams.getSortFields() == null || hotParams.getSortFields().isEmpty()) {
            hotParams.setSortFields((List<String>)new ArrayList<String>(){
                {
                    this.add("pubTime desc");
                }
            });
        }
        if (hotParams.getDuplicate().booleanValue()) {
            hotParams.setFacetField("cluster");
            hotParams.setFacetLimit((size == null ? 10 : size) * hotParams.getPage());
            hotParams.setEsResultProcessor(new EsHotTopicResultProcessor(hotParams.getPage(), size == null ? 10 : size));
            hotParams.setIEsBuildAgg(new EsHotTopicAgg(SortOrder.DESC, null));
        } else {
            hotParams.setFacetLimit(size == null ? 10 : size);
            hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        }
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor());
        return this.esExclusiveController.searchNews(hotParams);
    }

    public HotParams getHotParamsByPlanInfo(SpreadParam planInfo) {
        if (planInfo == null || planInfo.getPlanId() == null && planInfo.getName() == null || planInfo.getUser_token() == null) {
            throw new CustomException("params_error");
        }
        List<PlanInfoBean> planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfo);
        if (planInfoBeanList == null || planInfoBeanList.isEmpty()) {
            planInfo.setUser_token("default");
            planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfo);
            if (planInfoBeanList == null || planInfoBeanList.isEmpty()) {
                throw new CustomException("the_plan_found_empty");
            }
        }
        String catId = planInfo.getCatId();
        PlanInfoBean planInfoBean = planInfoBeanList.get(0);
        Integer planId = planInfoBean.getPlanId();
        final String keyWords = planInfoBean.getKeyWords();
        final String noKeywords = planInfoBean.getNoKeywords();
        String location = planInfo.getLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            location = planInfoBean.getLocation();
        }
        Integer size = planInfo.getSize();
        Integer page = planInfo.getPage();
        String facetField = planInfo.getFacetField();
        String emotionTendency = planInfo.getEmotionTendency();
        Date fromDt = planInfo.getFromDt();
        Date toDt = planInfo.getToDt();
        String day = planInfo.getDay();
        HotParams hotParams = new HotParams();
        if (catId != null) {
            hotParams.setCatId(catId);
        }
        if (planId != null) {
            hotParams.setPlanId(planId);
        }
        if (StringUtils.isNotBlank((CharSequence)keyWords)) {
            hotParams.setKeyWords((List<String>)new ArrayList<String>(){
                {
                    this.add(keyWords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)noKeywords)) {
            hotParams.setNoKeywords((List<String>)new ArrayList<String>(){
                {
                    this.add(noKeywords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)location)) {
            if ("title".equals(location)) {
                hotParams.setUseKeyWord("subject");
            }
            if ("content".equals(location)) {
                hotParams.setUseKeyWord("description");
            }
        }
        if (size != null) {
            hotParams.setSize(size);
        }
        if (page != null) {
            hotParams.setPage(page);
        }
        if (StringUtils.isNotBlank((CharSequence)facetField)) {
            hotParams.setFacetField(facetField);
        }
        if (StringUtils.isNotBlank((CharSequence)emotionTendency)) {
            hotParams.setEmotionTendency(emotionTendency);
        }
        if (StringUtils.isNotBlank((CharSequence)day)) {
            hotParams.setDay(day);
        } else {
            if (fromDt != null) {
                hotParams.setFromDt(fromDt);
            }
            if (toDt != null) {
                hotParams.setToDt(toDt);
            }
        }
        if (planInfo instanceof SearchSpreadNewsParam) {
            String keyWord;
            List<String> collect;
            SearchSpreadNewsParam sPlanInfo = (SearchSpreadNewsParam)planInfo;
            List<String> level = sPlanInfo.getLevel();
            List<String> newsType = sPlanInfo.getNewsType();
            List<String> sortFields = sPlanInfo.getSortFields();
            List<String> subjectKeyword = sPlanInfo.getSubjectKeyword();
            List<String> descriptionKeyword = sPlanInfo.getDescriptionKeyword();
            Boolean duplicate = sPlanInfo.getDuplicate();
            if (level != null) {
                hotParams.setLevel(level);
            }
            if (newsType != null) {
                hotParams.setNewsType(newsType);
            }
            if (sortFields != null) {
                hotParams.setSortFields(sortFields);
            }
            if (subjectKeyword != null && !subjectKeyword.isEmpty()) {
                if ("title".equals(location)) {
                    collect = subjectKeyword.stream().map(x -> {
                        x = x + "," + keyWords;
                        return x;
                    }).collect(Collectors.toList());
                    hotParams.setKeyWords(collect);
                } else {
                    keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(subjectKeyword);
                    hotParams.setSubject(keyWord);
                }
            }
            if (descriptionKeyword != null && !descriptionKeyword.isEmpty()) {
                if ("content".equals(location)) {
                    collect = descriptionKeyword.stream().map(x -> {
                        x = x + "," + keyWords;
                        return x;
                    }).collect(Collectors.toList());
                    hotParams.setKeyWords(collect);
                } else {
                    keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(descriptionKeyword);
                    hotParams.setDescription(keyWord);
                }
            }
            if (duplicate != null) {
                hotParams.setDuplicate(duplicate);
            }
        }
        return hotParams;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>(){
            {
                this.add("1");
                this.add("2");
                this.add("3");
                this.add("4");
            }
        };
        List collect = list.stream().map(x -> {
            x = x + 9;
            return x;
        }).collect(Collectors.toList());
        System.out.println(collect);
    }
}

