/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.backStageManagement.service.RegionService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.ArealDistributionProcessor;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.agg.EsTermBucketAgg;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.newservice.basic.bean.RegionalParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/regional-service"})
@CrossOrigin
public class RegionalNewsController {
    private static Logger logger = LogManager.getLogger(RegionalNewsController.class);
    @Autowired
    private RegionService regionService;
    @Autowired
    private EsNewsDataController esNewsDataController;

    @PostMapping(value={"/getArealDistribution"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getArealDistribution(@RequestBody RegionalParam regionalParam) {
        regionalParam.setFacetMincount(1);
        HotParamsUtils.setKeyWord(regionalParam);
        List<String> regionNames = regionalParam.getRegionNames();
        if (regionNames == null || regionNames.isEmpty()) {
            Integer regionCode = regionalParam.getRegionCode();
            CodeResult<List<Map<String, Object>>> addrTree = null;
            if (regionCode == null) {
                addrTree = this.regionService.getProvinces();
            } else {
                if (regionCode % 10000 == 0) {
                    regionalParam.setRegionType("city");
                } else if (regionCode % 1000 == 0) {
                    regionalParam.setRegionType("area");
                }
                addrTree = this.regionService.getAddrTree(regionCode.toString());
            }
            if (regionNames == null) {
                regionNames = new ArrayList<String>();
            }
            List<Map<String, Object>> result = addrTree.getResult();
            for (Map<String, Object> map : result) {
                Object name = map.get("name");
                if (name == null) continue;
                regionNames.add(name.toString());
            }
        }
        if (regionNames.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ArrayList<TermAggBucket> termAggBuckets = new ArrayList();
        termAggBuckets = regionNames.stream().map(x -> {
            if (x.endsWith("\u7701")) {
                return x.substring(0, x.lastIndexOf("\u7701"));
            }
            if (x.endsWith("\u5e02")) {
                return x.substring(0, x.lastIndexOf("\u5e02"));
            }
            if (x.endsWith("\u81ea\u6cbb\u533a")) {
                return x.substring(0, x.lastIndexOf("\u81ea\u6cbb\u533a"));
            }
            if (x.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                return x.substring(0, x.lastIndexOf("\u7279\u522b\u884c\u653f\u533a"));
            }
            if (x.endsWith("\u533a")) {
                return x.substring(0, x.lastIndexOf("\u533a"));
            }
            return x;
        }).collect(Collectors.toList()).stream().map(x -> new TermAggBucket(Arrays.asList(x), regionalParam.getRegionType(), (String)x)).collect(Collectors.toList());
        regionalParam.setFacetField(regionalParam.getRegionType());
        regionalParam.setNonEmptyField(regionalParam.getRegionType());
        regionalParam.setEsResultProcessor(new EsFacetResultProcessor());
        regionalParam.setParser(new FacetDataParser());
        regionalParam.setIEsBuildAgg(new EsTermBucketAgg(termAggBuckets));
        regionalParam.setAfterProcessor(new ArealDistributionProcessor(regionNames));
        return this.esNewsDataController.cluster(regionalParam);
    }
}

