/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.TrendProcessor;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statistic-service"})
@CrossOrigin
public class StatisticController {
    private static Logger logger = LogManager.getLogger(StatisticController.class);
    @Autowired
    private EsNewsDataController esNewsDataController;

    @PostMapping(value={"/getEventStatistics"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getEventStatistics(@RequestBody HotParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        return this.esNewsDataController.statisticNews(params);
    }

    @PostMapping(value={"/getTrend"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getTrend(@RequestBody HotParams params, BindingResult bindResult) {
        String timeType = "yyyy-MM-dd";
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeType));
        params.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url_MD5", "cardinality");
            }
        }, timeType));
        params.setAfterProcessor(new TrendProcessor((List<String>)new ArrayList<String>(){
            {
                this.add("url_MD5");
            }
        }));
        params.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeType));
        return this.esNewsDataController.trend(params);
    }
}

