/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.subscription.controller;

import com.chinamcloud.haihe.backStageManagement.controller.UserSiteManageController;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.service.SiteQueryService;
import com.chinamcloud.haihe.backStageManagement.service.UserSiteManageService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.newservice.subscription.bean.SubscriptionParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subscription-service"})
@CrossOrigin
public class SubscriptionController {
    private static Logger logger = LogManager.getLogger(UserSiteManageController.class);
    @Autowired
    private UserSiteManageService userSiteManageService;
    @Autowired
    private SiteQueryService siteQueryService;
    @Autowired
    private EsNewsDataController esNewsDataController;

    @UserLoginToken
    @PostMapping(value={"/getNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getSubscriptionSitesNews(@RequestBody SubscriptionParam subscriptionParam, HttpServletRequest request) {
        String user_token = request.getAttribute("user_token").toString();
        if (StringUtils.isBlank((CharSequence)user_token)) {
            logger.error("\u83b7\u53d6user_token\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("login_error");
        }
        if (subscriptionParam == null || subscriptionParam.getTypes() == null || subscriptionParam.getTypes().isEmpty()) {
            logger.error("\u6ca1\u6709\u4f20\u9012type\u6216\u8005\u662f\u83b7\u53d6type\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        CodeResult<List<Site>> result = this.userSiteManageService.getUserSubscription(subscriptionParam.getTypes(), user_token);
        List<Site> sites = result.getResult();
        if (sites.isEmpty()) {
            return CodeResult.successResult(null, Collections.emptyList());
        }
        HotParams params = this.editHotParam(subscriptionParam, sites, user_token);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        params.setAfterProcessor(new NewDetailAfterProcessor("page"));
        return this.esNewsDataController.getNewsList(params);
    }

    private HotParams editHotParam(SubscriptionParam subscriptionParam, List<Site> sites, String userToken) {
        List<String> siteId = this.getSiteId(sites);
        Integer page = subscriptionParam.getPage();
        Integer size = subscriptionParam.getSize();
        HotParams hotParams = new HotParams();
        hotParams.setPage(page == null || page < 0 ? 1 : page);
        hotParams.setSize(size == null || size < 0 ? 5 : size);
        hotParams.setPids(siteId);
        return hotParams;
    }

    private Map<String, List<String>> getSiteIdOrPid(List<Site> sites, String userToken) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> siteHead = new ArrayList<String>();
        ArrayList<String> siteListPage = new ArrayList<String>();
        for (final Site site : sites) {
            if (site.getPid().equals(0) || site.getSites() != null && !site.getSites().isEmpty()) {
                Map<String, List<String>> siteIdOrPid = this.getSiteIdOrPid(site.getSites(), userToken);
                List pidList = (List)map.get("pid");
                if (pidList == null) {
                    map.put("pid", siteIdOrPid.get("pid"));
                } else {
                    pidList.addAll((Collection)siteIdOrPid.get("pid"));
                }
                List siteList = (List)map.get("site");
                if (siteList == null) {
                    map.put("site", siteIdOrPid.get("site"));
                    continue;
                }
                siteList.addAll((Collection)siteIdOrPid.get("site"));
                continue;
            }
            Integer pagetype = site.getPagetype();
            Integer type = site.getType();
            if (pagetype == null || type == null) {
                if (site.getSiteId() == null) continue;
                CodeResult<Site> siteById = this.siteQueryService.getSiteById(site.getSiteId());
                Site site_db = siteById.getResult();
                pagetype = site_db.getPagetype();
                type = site_db.getType();
                site.setPagetype(pagetype);
                site.setType(type);
                Site site_temp = new Site();
                site_temp.setType(site.getType());
                site_temp.setSites((List<Site>)new ArrayList<Site>(){
                    {
                        this.add(site);
                    }
                });
                this.userSiteManageService.operatorSite(site_temp, userToken, "update");
            }
            if (type == 1 && pagetype != 1) {
                siteHead.add(site.getSiteId().toString());
                continue;
            }
            siteListPage.add(site.getSiteId().toString());
        }
        List pidList = (List)map.get("pid");
        if (pidList == null) {
            map.put("pid", siteHead);
        } else {
            pidList.addAll(siteHead);
        }
        List siteList = (List)map.get("site");
        if (siteList == null) {
            map.put("site", siteListPage);
        } else {
            siteList.addAll(siteListPage);
        }
        return map;
    }

    private List<String> getSiteId(List<Site> sites) {
        ArrayList<String> siteId = new ArrayList<String>();
        for (Site site : sites) {
            if (site.getPid().equals(0) || site.getSites() != null && !site.getSites().isEmpty()) {
                List<String> siteList = this.getSiteId(site.getSites());
                siteId.addAll(siteList);
                continue;
            }
            siteId.add(site.getSiteId().toString());
        }
        return siteId;
    }
}

